import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/helper/shared_preference_helper.dart';
import 'package:viser_remit/core/route/route.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/data/controller/home/home_controller.dart';
import '../../../core/utils/dimensions.dart';
import '../../../core/utils/my_color.dart';
import '../../../core/utils/my_images.dart';
import '../../../core/utils/style.dart';
import '../../../core/utils/util.dart';

class ViserRemitAppBar extends StatelessWidget implements PreferredSizeWidget {
  final String title;
  final double appBarHeight;
  final bool isElevation;
  final bool isTopPadding;
  final bool isShowLeading;
  const ViserRemitAppBar({super.key, required this.title, this.appBarHeight = 55, this.isElevation = false, this.isTopPadding = true, this.isShowLeading = true});

  @override
  Size get preferredSize => Size(double.maxFinite, appBarHeight);

  @override
  Widget build(BuildContext context) {
    MyUtils.allScreen();
    return GetBuilder<HomeController>(
      builder: (controller) => AppBar(
        // systemOverlayStyle: MyUtils.appbarSystemUiOverlayStyle,
        title: Text(title.tr, style: regularExtraLarge.copyWith(color: MyColor.colorWhite)),
        leading: isShowLeading
            ? IconButton(
                onPressed: () {
                  Get.back();
                },
                icon: const Icon(Icons.arrow_back_ios, color: MyColor.colorWhite),
              )
            : null,
        backgroundColor: MyColor.appBarColor,
        elevation: isElevation ? 1 : 0,
        actions: [
          GestureDetector(
            onTap: () {
              Get.toNamed(RouteHelper.languageScreen);
            },
            child: Container(
              margin: Dimensions.appBarMarginHV,
              padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 6),
              decoration: BoxDecoration(border: Border.all(color: MyColor.colorWhite), borderRadius: BorderRadius.circular(20)),
              child: Row(
                mainAxisSize: MainAxisSize.min,
                children: [
                  SvgPicture.asset(
                    MyImages.languageSymbol,
                    colorFilter: const ColorFilter.mode(MyColor.colorWhite, BlendMode.srcIn),
                  ),
                  const SizedBox(width: Dimensions.space8),
                  Text(
                    controller.homeRepo.apiClient.sharedPreferences.getString(SharedPreferenceHelper.languageName)??MyStrings.english,
                    style: mediumDefault.copyWith(color: MyColor.colorWhite),
                  ),
                  const SizedBox(width: Dimensions.space4),
                ],
              ),
            ),
          )
        ],
      ),
    );
  }
}
